/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class NoteBlockSlab
extends CustomSlabBlock {
    public static final EnumProperty<NoteBlockInstrument> INSTRUMENT = BlockStateProperties.f_61395_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final IntegerProperty NOTE = BlockStateProperties.f_61424_;

    public NoteBlockSlab(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(2.5f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(INSTRUMENT, (Comparable)NoteBlockInstrument.HARP)).m_61124_((Property)NOTE, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_(INSTRUMENT, (Comparable)NoteBlockInstrument.m_61666_((BlockState)context.m_43725_().m_8055_(context.m_8083_().m_7495_())));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN ? (BlockState)stateIn.m_61124_(INSTRUMENT, (Comparable)NoteBlockInstrument.m_61666_((BlockState)facingState)) : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int _new = ForgeHooks.onNoteChange((Level)level, (BlockPos)pos, (BlockState)state, (int)((Integer)state.m_61143_((Property)NOTE)), (int)((Integer)((BlockState)state.m_61122_((Property)NOTE)).m_61143_((Property)NOTE)));
        if (_new == -1) {
            return InteractionResult.FAIL;
        }
        state = (BlockState)state.m_61124_((Property)NOTE, (Comparable)Integer.valueOf(_new));
        level.m_7731_(pos, state, 3);
        this.triggerNote(level, pos);
        player.m_36220_(Stats.f_12960_);
        return InteractionResult.CONSUME;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.f_46443_) {
            this.triggerNote(level, pos);
            player.m_36220_(Stats.f_12959_);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.m_46753_(pos);
        if (flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag) {
                this.triggerNote(level, pos);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    private void triggerNote(Level level, BlockPos pos) {
        if (level.m_46859_(pos.m_7494_())) {
            level.m_7696_(pos, (Block)this, 0, 0);
        }
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(level, pos, state, ((Integer)state.m_61143_((Property)NOTE)).intValue(), (NoteBlockInstrument)state.m_61143_(INSTRUMENT));
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        state = (BlockState)((BlockState)state.m_61124_((Property)NOTE, (Comparable)Integer.valueOf(e.getVanillaNoteId()))).m_61124_(INSTRUMENT, (Comparable)e.getInstrument());
        int i = (Integer)state.m_61143_((Property)NOTE);
        float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
        level.m_5594_((Player)null, pos, ((NoteBlockInstrument)state.m_61143_(INSTRUMENT)).m_61668_(), SoundSource.RECORDS, 3.0f, f);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, (double)i / 24.0, 0.0, 0.0);
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{TYPE, WATERLOGGED, INSTRUMENT, POWERED, NOTE});
    }
}

